---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-メール通知（テキスト - Zurb 2）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.txt.twig`（Zurb 2テキストテンプレート、21行）
- E-02: `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php`（NotificationEmailクラス、281行）
- E-03: `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.txt.twig`（デフォルトテーマ、1行）
- E-04: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.html.twig`（HTML版テンプレート、67行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | leadブロックでemail.subjectを出力する | E-01 行1-3 `{% block lead %}{{ email.subject }}{% endblock %}` | ○ |
| C-02 | contentブロックでcontentを出力する | E-01 行5-7 `{% block content %}{{ content }}{% endblock %}` | ○ |
| C-03 | actionブロックでaction_url指定時にテキスト: URL形式で出力する | E-01 行9-13 `{% if action_url %}{{ action_text }}: {{ action_url }}{% endif %}` | ○ |
| C-04 | exceptionブロックで例外時に通知メッセージとexceptionを出力する | E-01 行15-21 `{% if exception %}Exception stack trace attached.\n{{ exception }}{% endif %}` | ○ |
| C-05 | 4つのTwigブロック（lead、content、action、exception）で構成される | E-01 ブロック定義の確認 | ○ |
| C-06 | テキスト版ではimportanceが出力されない | E-01（importanceを参照するコードなし） | ○ |
| C-07 | テキスト版ではfooter_textが出力されない | E-01（footer_textを参照するコードなし） | ○ |
| C-08 | テキスト版ではmarkdown/rawフラグが使用されない | E-01（markdown/rawを参照するコードなし） | ○ |
| C-09 | デフォルトテーマが本テンプレートを継承している | E-03 行1 `{% extends '@email/zurb_2/notification/body.txt.twig' %}` | ○ |
| C-10 | getTextTemplate()で@email/{theme}/notification/body.txt.twigを返す | E-02 行159-166 `return '@email/'.$this->theme.'/notification/body.txt.twig'` | ○ |
| C-11 | getExceptionAsString()で例外をテキスト化する | E-02 行237-253 | ○ |
| C-12 | getTextTemplate()はparent::getTextTemplate()を優先する | E-02 行160-161 `if ($template = parent::getTextTemplate()) { return $template; }` | ○ |
| C-13 | InkyやCSSインライン化の処理は不要 | E-01（apply/inky_to_html/inline_css なし） | ○ |
| C-14 | 関連機能としてNotifier（41）、Mailer（40）、Mime（42）、Twig Bridge（36） | E-05 行146-149 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] テキスト版で出力されない変数の記述がHTML版と整合しているか確認
- [ ] 4つのブロック構成が正確か確認
- [ ] デフォルトテーマとの継承関係が正確か確認
